/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.serialization;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.darkhax.bookshelf.crafting.block.BlockIngredient;
import net.darkhax.bookshelf.crafting.block.IBlockIngredientSerializer;
import net.darkhax.bookshelf.serialization.ISerializer;
import net.darkhax.bookshelf.serialization.Serializers;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public final class BlockIngredientSerializer
implements ISerializer<BlockIngredient> {
    public static final ISerializer<BlockIngredient> SERIALIZER = new BlockIngredientSerializer();

    private BlockIngredientSerializer() {
    }

    @Override
    public BlockIngredient read(JsonElement json) {
        JsonObject obj = json.getAsJsonObject();
        ResourceLocation id = Serializers.RESOURCE_LOCATION.read(obj.get("type"));
        IBlockIngredientSerializer<?> serializer = BlockIngredient.getSerializer(id);
        if (serializer != null) {
            return (BlockIngredient)serializer.read((JsonElement)obj);
        }
        throw new JsonParseException("Block ingredient type " + id + " could not be found!");
    }

    @Override
    public BlockIngredient read(PacketBuffer buf) {
        ResourceLocation id = Serializers.RESOURCE_LOCATION.read(buf);
        IBlockIngredientSerializer<?> serializer = BlockIngredient.getSerializer(id);
        if (serializer != null) {
            return (BlockIngredient)serializer.read(buf);
        }
        throw new IllegalStateException("Block ingredient type " + id + " could not be found!");
    }

    @Override
    public JsonElement write(BlockIngredient ingredient) {
        JsonElement element = this.writeUnsafe(ingredient);
        if (!element.isJsonObject()) {
            throw new IllegalStateException("Ingredient serializer " + ingredient.getSerializeId() + " returned " + element.getClass().getSimpleName() + " but expected " + JsonObject.class.getSimpleName() + ". This is a mod issue that needs to be fixed.");
        }
        JsonObject obj = element.getAsJsonObject();
        obj.add("type", Serializers.RESOURCE_LOCATION.write(ingredient.getSerializeId()));
        return element;
    }

    @Override
    public void write(PacketBuffer buf, BlockIngredient ingredient) {
        Serializers.RESOURCE_LOCATION.write(buf, ingredient.getSerializeId());
        this.writeUnsafe(buf, ingredient);
    }

    private <T extends BlockIngredient> JsonElement writeUnsafe(T ingredient) {
        IBlockIngredientSerializer<?> serializer = BlockIngredient.getSerializer(ingredient.getSerializeId());
        return serializer.write(ingredient);
    }

    private <T extends BlockIngredient> void writeUnsafe(PacketBuffer buf, T ingredient) {
        IBlockIngredientSerializer<?> serializer = BlockIngredient.getSerializer(ingredient.getSerializeId());
        serializer.write(buf, ingredient);
    }
}

